﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.SharePoint.Client;

namespace LinqQuery
{
   class Program
   {
      static void Main(string[] args)
      {
         ClientContext ctx = new ClientContext("http://contoso.de");

         Web web = ctx.Web;
         List orders = web.Lists.GetByTitle("Bestellungen");
         
         ListItemCollection items = orders.GetItems(
            new CamlQuery() { ViewXml = "<View/>" });
       
         // Eigenschaften des Listenelements einschränken
         // und Daten filtern         
         ctx.Load(items,
            item => item.Include(
               i => i["Kunde"],
               i => i["Artikel"],
               i => i["Menge"]
               ).Where(
               i => (int)i["Menge"] >= 5.0));

         ctx.ExecuteQuery();

         // Gefilterte Daten ausgeben
         foreach (ListItem i in items)
         {
            Console.WriteLine("Kunde: {0}",
              ((FieldLookupValue)i["Kunde"]).LookupValue);
            Console.WriteLine("Artikel: {0}",
               ((FieldLookupValue)i["Artikel"]).LookupValue);
            Console.WriteLine("Menge: {0}\n",
               i["Menge"]);
         }
      }
   }
}
